﻿//---zmienne globalne---
var playing = false;
var markerClicked = false;
var duration=0;
var intervalID;

//---główne elementy strony---
var ellMarker;
var MediaElement1;
var textblock;
var rectProgressWell;
var rectDownloadProgress;
//----------------------------------



if (!window.MediaPlayer)
	MediaPlayer = {};

MediaPlayer.Page = function() 
{
}

MediaPlayer.Page.prototype =
{
	handleLoad: function(control, userContext, rootElement) 
	{
		this.control = control;
		
           //---pobranie referencji najważniejszych elementów strony---
           MediaElement1 = rootElement.findName("MediaElement1");
           ellMarker = rootElement.findName("ellMarker");
           textblock = rootElement.findName("TextBlock");
           rectProgressWell = rootElement.findName("rectProgressWell");
           rectDownloadProgress = 
              rootElement.findName("rectDownloadProgress");
           textblock = rootElement.findName("TextBlock");
           //-----------------------------------------------------

		// Sample event hookup:	
		rootElement.addEventListener("MouseLeftButtonDown", Silverlight.createDelegate(this, this.handleMouseDown));
	},
	
	// Sample event handler
	handleMouseDown: function(sender, eventArgs) 
	{
		// The following line of code shows how to find an element by name and call a method on it.
		// this.control.content.findName("Storyboard1").Begin();
	}
}

//---konwersja czasu w sekundach do formatu "hh:mm:ss"---
function ConvertToTimeSpan(timeinseconds)
{
    if (timeinseconds<0) {
       return ("00:00:00");
    }
    else
    if (timeinseconds<60) {
       return ("00:00:" + Math.floor(timeinseconds));
    } 
    else
    if (timeinseconds<3600)
    {  
       var mins = Math.floor(timeinseconds / 60);
       var seconds = Math.floor(timeinseconds - (mins * 60));
       return ("00:" + mins + ":" + seconds);
    }
    else
    {
       var hrs = Math.floor(timeinseconds / 3600);
       var mins = timeinseconds - (hrs * 3600)
       var seconds = Math.floor(timeinseconds - (hrs * 3600) -  (mins * 60));
       return (hrs + mins + ":" + seconds);
    }
}


//---wyświetla aktualną pozycję odtwarzania -- znacznik i tekst---
function DisplayCurrentPlayBack()
{
    //---odczytanie czasu trwania filmu---
    if (duration==0)
       duration = Math.round(MediaElement1.NaturalDuration.Seconds * 100) / 
                  100; 

    //---odczytanie aktualnej pozycji---
    var position = MediaElement1.Position.Seconds;

    //---przesunięcie znacznika---
    ellMarker["Canvas.Left"] = Math.round((position / duration) * 
                               rectProgressWell.width);

    //---format - czas odtwarzania/czas całkowity---
    var str =  ConvertToTimeSpan(position) + "/" + 
               ConvertToTimeSpan(duration);

    textblock.Text = str;
}

//---wywoływana w czasie pobierania materiału wideo---
function DownloadProgressChanged(sender, eventArgs)
{
   //---pobranie wartości postępu pobierania (zakres od 0 do 1)---
   var progress = MediaElement1.DownloadProgress;

   //---wyświetlenie postępu w procentach---
   textblock.Text = Math.round(progress*100).toString() + "%";

   //---dostosowanie szerokości paska postępu---
   var progressWidth = progress * rectProgressWell.width;
   rectDownloadProgress.width = Math.round(progressWidth);
}
//---kliknięto znacznik---
function EllMarkerMouseDown(sender, eventArgs)
{
    markerClicked=true;
}
//---puszczono znacznik postępu---
function EllMarkerMouseUp(sender, eventArgs)
{
    //---funkcja jest wykonywana tylko wtedy, gdy użytkownik przeciągał znacznik---
    if (markerClicked) {
       markerClicked=false;

       //---odczytanie czasu trwania filmu---
       duration = Math.round(MediaElement1.NaturalDuration.Seconds * 
                  100)/100;          

       //---odczytanie pozycji znacznika w pasku postępu---
       position = ((ellMarker["Canvas.Left"]) / rectProgressWell.width) * 
                  duration;

       //---interesuje nas tylko część całkowita---
       position = Math.floor(position);

       //---koniec materiału---
       if (ellMarker["Canvas.Left"]==rectProgressWell.width) {
          //---przewijanie materiału do ostatniej klatki---
          MediaElement1.Position = ConvertToTimeSpan(duration);
       }
       else
       {
          //---przewinięcie materiału do nowej pozycji---
          MediaElement1.Position = ConvertToTimeSpan(position);
       }
    }
}
//---wskaźnik myszy przesuwany jest nad kontrolką odtwarzacza wideo---
function MediaPlayerMouseMove(sender, eventArgs)
{
   //---użytkownik kliknąć znacznik i go przeciąga---
   if (markerClicked)
   {
      //---odczytanie czasu trwania materiału---
      if (duration==0)
          duration = Math.round(MediaElement1.NaturalDuration.Seconds * 100) 
                     / 100; 

      clearInterval(intervalID);

      //---odczytanie pozycji wskaźnika myszy względem paska postępu---
      var pt = eventArgs.getPosition(rectProgressWell);

      //---znacznik nie może znaleźć się poza paskiem postępu---
      if (pt.x > 0 && pt.x < rectProgressWell.width)
      {
          //---przesunięcie znacznika---
          ellMarker["Canvas.Left"] = pt.x;

          //---wyświetlenie nowego czasu---
          textblock.Text = ConvertToTimeSpan((pt.x / rectProgressWell.width) 
                           * duration).toString();
      } 
      else 
      if (pt.x <= 0)  //---przesunięcie na początek---
      {
          //---przesunięcie znacznika---
          ellMarker["Canvas.Left"] = 0;

          //---wyświetlenie nowego czasu---
          textblock.Text = "00:00:00";
      } 
      else
      if (pt.x >= rectProgressWell.width) //---przesunięcie na koniec---
      {
          //---przesunięcie znacznika---
          ellMarker["Canvas.Left"] = rectProgressWell.width; 

          //---wyświetlenie nowego czasu---
          textblock.Text = ConvertToTimeSpan(duration);
      }

      if (playing) 
         intervalID = window.setInterval("DisplayCurrentPlayBack()", 500);
   } 
}



//---wskaźnik myszy znalazł się poza obszarem odtwarzacza---
function MediaPlayerMouseLeave(sender, eventArgs)
{
    markerClicked=false;
}

//---odtwarzania filmu zostało zakończone---
function MediaEnded(sender, eventArgs)
{
    var btnPlay = sender.findName("canvasPlay");
    var btnPause = sender.findName("canvasPause");

    playing = false;
    clearInterval(intervalID);    //---wyłączenie aktualizowania---
    btnPlay.opacity = 1;          //---wyświetlenie przycisku Odtwarzaj---
    btnPause.opacity = 0;         //---ukrycie przycisku Zatrzymaj---

    //---przesunięcie znacznika na początek---
    ellMarker["Canvas.Left"] = -2;
    MediaElement1.Position="00:00:00"; //---przewinięcie wideo do początku---
}

function PlayPauseButtonUp(sender, eventArgs)
{  
   var btnPlay = sender.findName("canvasPlay");
   var btnPause = sender.findName("canvasPause");

   //---jeżeli aktualnie odtwarzanie jest włączone, to trzeba je zatrzymać---
   if (playing==true) {   
      MediaElement1.pause();      //---zatrzymanie odtwarzania---
      clearInterval(intervalID);  //---zatrzymanie aktualizowania znacznika---
      playing = false;
      btnPlay.opacity = 1;        //---wyświetlenie przycisku Odtwórz---
      btnPause.opacity = 0;       //---ukrycie przycisku Zatrzymaj---
   } 
   else
   {
      MediaElement1.play();       //---włączenie odtwarzania---
      playing = true;
      btnPlay.opacity = 0;        //---ukrycie przycisku Odtwórz---
      btnPause.opacity = 1;       //---wyświetlenie przycisku Zatrzymaj---

      //---aktualizacja postępu wyświetlania---
      intervalID = window.setInterval("DisplayCurrentPlayBack()", 500);
   }
}




















